/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef ARTIFACTFREEPOINTSWIDGETHEADERFILE
#define ARTIFACTFREEPOINTSWIDGETHEADERFILE

#include <QWidget>

#include "../../core/vector3.h"

class QLineEdit;
class QListWidget;
class QToolButton;
class QListWidgetItem;

class TXmlFile;

class TArtifactFreePointsWidget : public QWidget
{
Q_OBJECT

public:
	
struct TPointData
{
	QString								description;
	TVector3							xyz;
	TVector3							ijk;
};


// CREATORS
	TArtifactFreePointsWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TArtifactFreePointsWidget(void);

// ACCESSORS

	bool Save_Touch_Points(const QString &data_path) const;
	
// MANIPULATORS
	bool Load_Touch_Points(const QString &data_path);

signals:
	void Touch_Point(const double&,const double&,const double&,const double&,const double&,const double&);	// xyzijk

private slots:
	void Description_Changed(const QString&);
	void Add_Touch(void);
	void Delete_Touch_Points(void);
	void Send_Touch(void);
	
	void Touch_Selection_Changed(void);
	void Touch_Double_Clicked(QListWidgetItem*);

private:
	QLineEdit							*d_dir_i_edit;
	QLineEdit							*d_dir_j_edit;
	QLineEdit							*d_dir_k_edit;
	QLineEdit							*d_name_edit;
	QLineEdit							*d_pos_x_edit;
	QLineEdit							*d_pos_y_edit;
	QLineEdit							*d_pos_z_edit;
	QListWidget							*d_points_list;
	QToolButton							*d_add_button;
	QToolButton							*d_remove_button;
	QToolButton							*d_send_button;
	
	bool Save_Data(const QString &file_name) const;
	bool Load_Data(const QString &file_name);
	
	void Load_Data_V1(TXmlFile * const xml_file);


// NOT IMPLEMENTED
	TArtifactFreePointsWidget(const TArtifactFreePointsWidget&);
	TArtifactFreePointsWidget& operator=(const TArtifactFreePointsWidget&);
};

#endif
