/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef BUFFERDISPLAYWIDGETHEADERFILE
#define BUFFERDISPLAYWIDGETHEADERFILE

#include <QWidget>
#include <QFile>

class QListWidget;
class QListWidgetItem;
class QSpinBox;
class QCheckBox;

class TBufferDisplayWidget : public QWidget
{
Q_OBJECT

public:

enum TMode
{
	BUFFER_SEND = 0,
	BUFFER_RECEIVE
};

// CREATORS
	TBufferDisplayWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TBufferDisplayWidget(void);

// ACCESSORS
	int Buffer_Size(void) const;

// MANIPULATORS
	void Clear(void);
	void Add_Entry(const TMode mode,const QString &text);
	void Set_Buffer_Size(const int size);

signals:

private slots:
	void Log_File(int);

private:
	QListWidget							*d_buffer_list;
	QSpinBox							*d_buffer_spin;
	QCheckBox							*d_log_file_check;
	int									d_command_number;
	QFile								d_log_file;

// NOT IMPLEMENTED
	TBufferDisplayWidget(const TBufferDisplayWidget&);
	TBufferDisplayWidget& operator=(const TBufferDisplayWidget&);
};

#endif
