/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef MACHINEOFFLINEHEADERFILE
#define MACHINEOFFLINEHEADERFILE

#include "machine.h"

class TMachineOffline : public TMachine
{
	Q_OBJECT
	
public:
	// CREATORS
	TMachineOffline(void);
	virtual ~TMachineOffline(void);
	
	// ACCESSORS
	virtual QString Machine_Description(void) const {return QStringLiteral("Offline");}
	virtual QByteArray KeyPress_Done(void) const;
	virtual QByteArray KeyPress_DelPnt(void) const;

	// MANIPULATORS
	virtual void Process_Rx(const QByteArray &new_data);
	
	virtual void Set_EStop(const bool state);
	virtual bool Move_To(const TVector3 &pos);
	virtual bool Manual_Touch(const TVector3 &pos,const TVector3 &vec);
	virtual bool Jog_Move(const TVector3 &direction);
	
private:
	
	// NOT IMPLEMENTED
	TMachineOffline(const TMachineOffline&);
	TMachineOffline& operator=(const TMachineOffline&);
};

#endif
