/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QGridLayout>
#include <QTableWidget>
#include <QHeaderView>

#include "machineattributeswidget.h"

TMachineAttributesWidget::TMachineAttributesWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	QGridLayout							*widget_layout;
	QTableWidgetItem					*column_item_1;
	QTableWidgetItem					*column_item_2;
	QTableWidgetItem					*column_item_3;
	QTableWidgetItem					*row_item_1;
	QTableWidgetItem					*row_item_2;
	QTableWidgetItem					*row_item_3;
	QTableWidgetItem					*row_item_4;
	QTableWidgetItem					*part_x_min_item;
	QTableWidgetItem					*part_x_max_item;

	widget_layout = new QGridLayout(this);
	widget_layout->setContentsMargins(0,0,0,0);

	d_attributes_widget = new QTableWidget(this);
	
	// headers
	d_attributes_widget->setColumnCount(3);
	d_attributes_widget->setRowCount(4);
	
	column_item_1 = new QTableWidgetItem();
	column_item_1->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setHorizontalHeaderItem(0,column_item_1);
	
	column_item_2 = new QTableWidgetItem();
	column_item_2->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setHorizontalHeaderItem(1,column_item_2);
	
	column_item_3 = new QTableWidgetItem();
	column_item_3->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setHorizontalHeaderItem(2,column_item_3);
		
	row_item_1 = new QTableWidgetItem();
	row_item_1->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setVerticalHeaderItem(0,row_item_1);
	
	row_item_2 = new QTableWidgetItem();
	row_item_2->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setVerticalHeaderItem(1,row_item_2);
	
	row_item_3 = new QTableWidgetItem();
	row_item_3->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setVerticalHeaderItem(2,row_item_3);
	
	row_item_4 = new QTableWidgetItem();
	row_item_4->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setVerticalHeaderItem(3,row_item_4);
	
	// data
	d_x_min_item = new QTableWidgetItem();
	d_x_min_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_x_min_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(0,0,d_x_min_item);
	
	d_y_min_item = new QTableWidgetItem();
	d_y_min_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_y_min_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(1,0,d_y_min_item);
	
	d_z_min_item = new QTableWidgetItem();
	d_z_min_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_z_min_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(2,0,d_z_min_item);
	
	part_x_min_item = new QTableWidgetItem();
	part_x_min_item->setFlags(Qt::ItemIsEnabled);
	d_attributes_widget->setItem(3,0,part_x_min_item);

	d_x_max_item = new QTableWidgetItem();
	d_x_max_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_x_max_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(0,1,d_x_max_item);
	
	d_y_max_item = new QTableWidgetItem();
	d_y_max_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_y_max_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(1,1,d_y_max_item);
	
	d_z_max_item = new QTableWidgetItem();
	d_z_max_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_z_max_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(2,1,d_z_max_item);
	
	part_x_max_item = new QTableWidgetItem();
	part_x_max_item->setFlags(Qt::ItemIsEnabled);
	d_attributes_widget->setItem(3,1,part_x_max_item);

	d_x_temp_item = new QTableWidgetItem();
	d_x_temp_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_x_temp_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(0,2,d_x_temp_item);
	
	d_y_temp_item = new QTableWidgetItem();
	d_y_temp_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_y_temp_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(1,2,d_y_temp_item);
	
	d_z_temp_item = new QTableWidgetItem();
	d_z_temp_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_z_temp_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(2,2,d_z_temp_item);
	
	d_part_temp_item = new QTableWidgetItem();
	d_part_temp_item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable);
	d_part_temp_item->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	d_attributes_widget->setItem(3,2,d_part_temp_item);

	widget_layout->addWidget(d_attributes_widget,0,0,1,1);
	
	d_attributes_widget->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
	
	// defaults
	this->Set_Min_X(0.0);
	this->Set_Min_Y(0.0);
	this->Set_Min_Z(-1000.0);
	this->Set_Max_X(1200.0);
	this->Set_Max_Y(2200.0);
	this->Set_Max_Z(0.0);
	this->Set_Temp_X(20.0);
	this->Set_Temp_Y(20.0);
	this->Set_Temp_Z(20.0);
	this->Set_Temp_Part(20.0);

	column_item_1->setText(QStringLiteral("Min"));
	column_item_2->setText(QStringLiteral("Max"));
	column_item_3->setText(QStringLiteral("Temp. ˚C"));
	row_item_1->setText(QStringLiteral("X"));
	row_item_2->setText(QStringLiteral("Y"));
	row_item_3->setText(QStringLiteral("Z"));
	row_item_4->setText(QStringLiteral("Part"));
	
	connect(d_attributes_widget,&QTableWidget::cellChanged,this,&TMachineAttributesWidget::Value_Changed);

}

TMachineAttributesWidget::~TMachineAttributesWidget(void)
{
}

double TMachineAttributesWidget::Min_X(void) const
{
	double								v1,v2;
	
	v1 = d_x_min_item->text().toDouble();
	v2 = d_x_max_item->text().toDouble();
	
	if(v1 < v2)
	{
		return v1;
	}
	
	return v2;
}

double TMachineAttributesWidget::Min_Y(void) const
{
	double								v1,v2;
	
	v1 = d_y_min_item->text().toDouble();
	v2 = d_y_max_item->text().toDouble();
	
	if(v1 < v2)
	{
		return v1;
	}
	
	return v2;
}

double TMachineAttributesWidget::Min_Z(void) const
{
	double								v1,v2;
	
	v1 = d_z_min_item->text().toDouble();
	v2 = d_z_max_item->text().toDouble();
	
	if(v1 < v2)
	{
		return v1;
	}
	
	return v2;
}

double TMachineAttributesWidget::Max_X(void) const
{
	double								v1,v2;
	
	v1 = d_x_min_item->text().toDouble();
	v2 = d_x_max_item->text().toDouble();
	
	if(v1 > v2)
	{
		return v1;
	}
	
	return v2;
}

double TMachineAttributesWidget::Max_Y(void) const
{
	double								v1,v2;
	
	v1 = d_y_min_item->text().toDouble();
	v2 = d_y_max_item->text().toDouble();
	
	if(v1 > v2)
	{
		return v1;
	}
	
	return v2;
}

double TMachineAttributesWidget::Max_Z(void) const
{
	double								v1,v2;
	
	v1 = d_z_min_item->text().toDouble();
	v2 = d_z_max_item->text().toDouble();
	
	if(v1 > v2)
	{
		return v1;
	}
	
	return v2;
}

double TMachineAttributesWidget::Temp_X(void) const
{
	return d_x_temp_item->text().toDouble();
}

double TMachineAttributesWidget::Temp_Y(void) const
{
	return d_y_temp_item->text().toDouble();
}

double TMachineAttributesWidget::Temp_Z(void) const
{
	return d_z_temp_item->text().toDouble();
}

double TMachineAttributesWidget::Temp_Part(void) const
{
	return d_part_temp_item->text().toDouble();
}

void TMachineAttributesWidget::Set_Min_X(
	const double 						&value)
{
	d_x_min_item->setText(QString::number(value,'f',3));
}

void TMachineAttributesWidget::Set_Min_Y(
	const double 						&value)
{
	d_y_min_item->setText(QString::number(value,'f',3));
}

void TMachineAttributesWidget::Set_Min_Z(
	const double 						&value)
{
	d_z_min_item->setText(QString::number(value,'f',3));
}

void TMachineAttributesWidget::Set_Max_X(
	const double 						&value)
{
	d_x_max_item->setText(QString::number(value,'f',3));
}

void TMachineAttributesWidget::Set_Max_Y(
	const double 						&value)
{
	d_y_max_item->setText(QString::number(value,'f',3));
}

void TMachineAttributesWidget::Set_Max_Z(
	const double 						&value)
{
	d_z_max_item->setText(QString::number(value,'f',3));
}

void TMachineAttributesWidget::Set_Temp_X(
	const double 						&value)
{
	d_x_temp_item->setText(QString::number(value,'f',2));
}

void TMachineAttributesWidget::Set_Temp_Y(
	const double 						&value)
{
	d_y_temp_item->setText(QString::number(value,'f',2));
}

void TMachineAttributesWidget::Set_Temp_Z(
	const double 						&value)
{
	d_z_temp_item->setText(QString::number(value,'f',2));
}

void TMachineAttributesWidget::Set_Temp_Part(
	const double 						&value)
{
	d_part_temp_item->setText(QString::number(value,'f',2));
}
