/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MACHINEATTRIBUTESWIDGETHEADERFILE
#define MACHINEATTRIBUTESWIDGETHEADERFILE

#include <QWidget>

class QTableWidget;
class QTableWidgetItem;

class TMachineAttributesWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TMachineAttributesWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TMachineAttributesWidget(void);

// ACCESSORS
	double Min_X(void) const;
	double Min_Y(void) const;
	double Min_Z(void) const;
	double Max_X(void) const;
	double Max_Y(void) const;
	double Max_Z(void) const;
	double Temp_X(void) const;
	double Temp_Y(void) const;
	double Temp_Z(void) const;
	double Temp_Part(void) const;

// MANIPULATORS
	void Set_Min_X(const double &value);
	void Set_Min_Y(const double &value);
	void Set_Min_Z(const double &value);
	void Set_Max_X(const double &value);
	void Set_Max_Y(const double &value);
	void Set_Max_Z(const double &value);
	void Set_Temp_X(const double &value);
	void Set_Temp_Y(const double &value);
	void Set_Temp_Z(const double &value);
	void Set_Temp_Part(const double &value);
	
signals:
	void Value_Changed(void);

private slots:

private:
	QTableWidget						*d_attributes_widget;
	QTableWidgetItem					*d_x_min_item;
	QTableWidgetItem					*d_y_min_item;
	QTableWidgetItem					*d_z_min_item;
	QTableWidgetItem					*d_x_max_item;
	QTableWidgetItem					*d_y_max_item;
	QTableWidgetItem					*d_z_max_item;
	QTableWidgetItem					*d_x_temp_item;
	QTableWidgetItem					*d_y_temp_item;
	QTableWidgetItem					*d_z_temp_item;
	QTableWidgetItem					*d_part_temp_item;

// NOT IMPLEMENTED
	TMachineAttributesWidget(const TMachineAttributesWidget&);
	TMachineAttributesWidget& operator=(const TMachineAttributesWidget&);
};

#endif
