/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef PROTOCOLDIALOGHEADERFILE
#define PROTOCOLDIALOGHEADERFILE

#include <QDialog>
#include <QSerialPort>

class QWidget;
class QObject;
class QPushButton;
class QLabel;
class QTimer;
class QCloseEvent;

class TOptionEditorWidget;

class TProtocolDialog : public QDialog
{
    Q_OBJECT
	
public:
	
	
enum TControllerType
{
	CONTROLLER_VIRTUALCMM = 0,
	CONTROLLER_LEITZ,
	CONTROLLER_DC,
	CONTROLLER_IPP
};

enum TProtocolType
{
	PROTOCOL_SERIAL = 0,
	PROTOCOL_ETHERNET
};
	
// CREATORS
    TProtocolDialog(const QWidget *parent=0,Qt::WindowFlags flags=Qt::WindowFlags());
    ~TProtocolDialog(void);
	
// ACCESSORS
	TControllerType Controller_Type(void) const;
	TProtocolType Connection_Type(void) const;
	QString Comm_Port(void) const;
	QSerialPort::BaudRate Baud_Rate(void);
	QString Ethernet_Address(void) const;
	int Ethernet_Port(void) const;

// MANIPULATORS
	void Set_Controller_Type(const TControllerType type);
	void Set_Connection_Type(const TProtocolType type);
	void Set_Comm_Port(const QString &port_name);
	void Set_Baud_Rate(const QSerialPort::BaudRate baud_rate);
	void Set_Ethernet_Address(const QString &ethernet_address);
	void Set_Ethernet_Port(const int port);
	
	void Reset(void);
	
	
private slots:
	void Option_Combo_Item_Changed(int,const QString&);
	void Accept(void);

private:
	
	QPushButton							*d_accept_button;
	QPushButton							*d_cancel_button;
	
	TOptionEditorWidget					*d_option_editor;
	
	int									d_controller_type_index;
	int									d_protocol_type_index;
	int									d_serial_comport_index;
	int									d_serial_baud_index;
	int									d_ethernet_hostname_index;
	int									d_ethernet_portnumber_index;
	
	TControllerType						d_controller_type;
	TProtocolType						d_connection_type;
	QSerialPort::BaudRate				d_serial_baudrate;
	QString								d_serial_portname;
	QString								d_ethernet_address;
	int									d_ethernet_port;
	
	void Create_Options(void);

	QSerialPort::BaudRate Convert_Baudrate_Option(const QString &option_text);
	
// NOT IMPLEMENTED
    TProtocolDialog(const TProtocolDialog&);
    TProtocolDialog& operator=(const TProtocolDialog&);
	
};


#endif
