CONFIG +=			release \
					warn_on \
					qt \
					thread \
					c++11

# DEBUG MODE LEVEL. 0 = show missing commands and all char's below 0x20
#                   1 = all commands

# DEFINES	+=			DEBUG_MODE_LEVEL_0
# DEFINES	+=			DEBUG_MODE_LEVEL_1

TEMPLATE =			app
DESTDIR =			bin

CONFIG(debug, debug|release) {
	TARGET =		virtualcmmd
} else {
	TARGET =		virtualcmm
}

OBJECTS_DIR =		build/obj
MOC_DIR =			build/moc

QT +=				core \
					gui \
					opengl \
					xml \
					network \
					serialport
					

greaterThan(QT_MAJOR_VERSION, 4): {
QT +=				widgets
}

greaterThan(QT_MAJOR_VERSION, 5): {
QT +=				openglwidgets
}

# DEPENDPATH +=		<relative path>/lib
# INCLUDEPATH +=	<relative path>/src
# LIBS+=			-L<relative path>/lib -l<library name>

SOURCES +=			../core/mat4.cpp \
					../core/messagebox.cpp \
					../core/openglgeometryfactory.cpp \
					../core/openglvertexbuffer.cpp \
					../core/openglwidget.cpp \
					../core/optioneditor.cpp \
					../core/vector2.cpp \
					../core/vector3.cpp \
					../core/xmlfile.cpp \
					src/artifactballbarwidget.cpp \
					src/artifactcontainerwidget.cpp \
					src/artifactfreepointswidget.cpp \
					src/artifactgaugeblockwidget.cpp \
					src/artifactringgaugewidget.cpp \
					src/artifactspherewidget.cpp \
					src/artifactstepgaugewidget.cpp \
					src/bufferdisplaywidget.cpp \
					src/command_executor.cpp \
					src/coordinatedisplaywidget.cpp \
					src/coordinatewidget.cpp \
					src/jogboxdialog.cpp \
					src/machine.cpp \
					src/machine_dc.cpp \
					src/machine_dock.cpp \
					src/machine_ipp.cpp \
					src/machine_leitz.cpp \
					src/machine_offline.cpp \
					src/machineattributeswidget.cpp \
					src/machineerrorsdialog.cpp \
					src/main.cpp \
					src/opengldisplay.cpp \
					src/opengldisplaywidget.cpp \
					src/protocoldialog.cpp \
					src/virtualcmm.cpp

HEADERS +=			../core/mat4.h \
					../core/messagebox.h \
					../core/openglgeometryfactory.h \
					../core/openglshaders.h \
					../core/openglvertexbuffer.h \
					../core/openglwidget.h \
					../core/optioneditor.h \
					../core/vector2.h \
					../core/vector3.h \
					../core/xmlfile.h \
					src/artifactballbarwidget.h \
					src/artifactcontainerwidget.h \
					src/artifactfreepointswidget.h \
					src/artifactgaugeblockwidget.h \
					src/artifactpointtype.h \
					src/artifactringgaugewidget.h \
					src/artifactspherewidget.h \
					src/artifactstepgaugewidget.h \
					src/bufferdisplaywidget.h \
					src/command_executor.h \
					src/coordinatedisplaywidget.h \
					src/coordinatewidget.h \
					src/jogboxdialog.h \
					src/machine.h \
					src/machine_dc.h \
					src/machine_dock.h \
					src/machine_ipp.h \
					src/machine_leitz.h \
					src/machine_offline.h \
					src/machineattributeswidget.h \
					src/machineerrorsdialog.h \
					src/opengldisplay.h \
					src/opengldisplaywidget.h \
					src/protocoldialog.h \
					src/virtualcmm.h

RESOURCES +=		res/virtualcmm.qrc

macx{

ICON =			res/icons.icns
QMAKE_INFO_PLIST = ../default_data/Info.plist
}

linux-g++{

isEmpty(PREFIX) {
PREFIX = 			/usr/lib/virtualcmm
}
target.path =		$$PREFIX
target.files =		bin/virtualcmm
INSTALLS +=			target
}

win32 {
RC_FILE =			res/resource.rc
}
