/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef DCCONTROLLERSTATUSHEADERFILE
#define DCCONTROLLERSTATUSHEADERFILE

#include <QDialog>
#include <QString>
#include <QByteArray>
#include <QAbstractSocket>
#include <vector>

class QLabel;
class QLineEdit;
class QPlainTextEdit;
class QToolButton;
class QCloseEvent;
class QSettings;
class QTcpSocket;
class QTimer;

class TDCControllerStatus : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TDCControllerStatus(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TDCControllerStatus(void);

// ACCESSORS

// MANIPULATORS

signals:

private slots:
	void Update(void);
	void Close_Socket(void);
	void Save(void);
	
	void Socket_Connected(void);
	void Socket_Disconnected(void);
	void Socket_Error(QAbstractSocket::SocketError);
	void Socket_State_Changed(QAbstractSocket::SocketState);
	void Socket_Read(void);
	
protected:
	virtual void closeEvent(QCloseEvent *event);

private:
	
	QLabel								*d_relays_label;
	QLabel								*d_estop_label;
	QLabel								*d_autzer_label;
	QLabel								*d_prbtype_label;
	QLabel								*d_prbstatus_label;
	QLabel								*d_machine_type_label;
	QLabel								*d_machine_serial_label;
	QLabel								*d_fw_version_label;
	
	QLabel								*d_tempcomptype_label;
	QLabel								*d_volcomp_type_label;
	QLabel								*d_volcomp_label;
	QLabel								*d_geo_label;
	QLabel								*d_mapstat_label;
	QLabel								*d_dyncomp_label;
	
	QLabel								*d_x_cte_label;
	QLabel								*d_y_cte_label;
	QLabel								*d_z_cte_label;
	QLabel								*d_x_temperature_label;
	QLabel								*d_y_temperature_label;
	QLabel								*d_z_temperature_label;
	QLabel								*d_w_temperature_label;
	QLabel								*d_part_temperature_label;
	
	QLineEdit							*d_controller_ip_edit;
	QLineEdit							*d_controller_port_edit;
	QPlainTextEdit						*d_controller_log_edit;
	QPlainTextEdit						*d_communication_log_edit;
	QToolButton							*d_update_button;
	QToolButton							*d_save_button;
	QSettings							*d_settings;
	QTcpSocket							*d_active_tcp_socket;
	QTimer								*d_close_socket_timer;

	QByteArray							d_rx_data;
	QString								d_application_path;
	QString								d_data_path;
	int									d_display_error_number;
	bool								d_waiting_for_ready;
	bool								d_waiting_for_error_history;

	std::vector<QString>				d_command_queue;
	
	void Process_Rx_Data(QTcpSocket * const socket);
	
	void Clear_Error_Log(void);
	void Add_Error_Log_Text(const QString &text);

	void Clear_Status_Log(void);
	void Add_Status_Log_Text(const QString &text);
	
	void Initialize_Connection(QTcpSocket * const socket);
	void Initialize_Command_Queue(void);

// NOT IMPLEMENTED
	TDCControllerStatus(const TDCControllerStatus&);
	TDCControllerStatus& operator=(const TDCControllerStatus&);
};

#endif
