/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <assert.h>

#include "vector3.h"

TVector3::TVector3(void)
:x(0),
 y(0),
 z(0)
{
}

TVector3::TVector3(
    const TVector3                  	&lhs)
{
	x = lhs.x;
	y = lhs.y;
	z = lhs.z;
}

TVector3::TVector3(
    const double                  		&X,
    const double                  		&Y,
    const double                  		&Z)
:x(X),
 y(Y),
 z(Z)
{
}

TVector3::~TVector3(void)
{

}

double TVector3::operator()(
	const int							Offset) const
{
	switch(Offset)
	{
		case 0:
			return x;

		case 1:
			return y;

		case 2:
			return z;
	}

	assert(false);

	return 0;
}

double& TVector3::operator()(
	const int							Offset)
{
	switch(Offset)
	{
		case 0:
			return x;

		case 1:
			return y;

		case 2:
			return z;
	}

	assert(false);

	return x;
}

TVector3& TVector3::Normal(void)
{
     double                        		Length;

     Length = sqrt(x*x + y*y + z*z);

     assert(Length > std::numeric_limits<double>::epsilon());

     x/= Length;
     y/= Length;
     z/= Length;

     return *this;
}

TVector3& TVector3::operator*=(
     const TVector3                  	&lhs)
{
     double                        		it;
     double                        		jt;
     double                        		kt;

     if(&lhs != this)
     {
          it = j*lhs.k - k*lhs.j;
          jt = k*lhs.i - i*lhs.k;
          kt = i*lhs.j - j*lhs.i;

          i = it;
          j = jt;
          k = kt;
     }

     return *this;
}

double operator^(
     const TVector3                  	&a,
     const TVector3                  	&b)
{
     return a.i*b.i + a.j*b.j + a.k*b.k;
}


TVector3 operator*(
     const TVector3                  	&a,
     const TVector3                  	&b)
{
      return TVector3(a)*=b;
}

TVector3 operator*(
     const TVector3                  	&a,
     const double                  	&d)
{
     return TVector3(a)*=d;
}

TVector3 operator*(
     const double                  	&d,
     const TVector3                  	&a)
{
     return TVector3(a)*=d;
}

TVector3 operator+(
     const TVector3                  	&a,
     const TVector3                  	&b)
{
     return TVector3(a)+=b;
}

TVector3 operator+(
     const TVector3                  	&a,
     const double                  	&d)
{
     return TVector3(a)+=d;
}

TVector3 operator+(
     const double                  	&d,
     const TVector3                  	&a)
{
     return TVector3(a)+=d;
}

TVector3 operator-(
     const TVector3                  	&a,
     const TVector3                  	&b)
{
     return TVector3(a)-=b;
}

TVector3 operator-(
     const TVector3                  	&a,
     const double                  	&d)
{
     return TVector3(a)-=d;
}

TVector3 operator-(
     const double                  	&d,
     const TVector3                  	&a)
{
     return TVector3(a)-=d;
}

TVector3 operator/(
	const TVector3					&v,
	const double					&d)
{
    return TVector3(v)/=d;
}
