CONFIG +=			release \
					warn_on \
					qt \
					thread \
					c++11

TEMPLATE =			app
DESTDIR =			bin

CONFIG(debug, debug|release) {
	TARGET =		deflectionsimulatord
} else {
	TARGET =		deflectionsimulator
}

OBJECTS_DIR =		build/obj
MOC_DIR =			build/moc

QT +=				core \
					gui \
					xml

greaterThan(QT_MAJOR_VERSION, 4): {
QT +=				widgets

}

# DEPENDPATH +=		<relative path>/lib
# INCLUDEPATH +=	<relative path>/src
# LIBS+=			-L<relative path>/lib -l<library name>

SOURCES +=			../core/vector2.cpp \
					../core/vector3.cpp \
					../core/xmlfile.cpp \
					../core/messagebox.cpp \
					src/deflectionmodel.cpp \
					src/deflectionsimulator.cpp \
					src/displaywidget.cpp \
					src/genericdeflectionmodel.cpp \
					src/lkdeflectionmodel.cpp \
					src/main.cpp \
					src/measurementdata.cpp \
					src/measurementeditwidget.cpp \
					src/renishawdeflectionmodel.cpp

HEADERS +=			../core/vector2.h \
					../core/vector3.h \
					../core/xmlfile.h \
					../core/messagebox.h \
					src/deflectionmodel.h \
					src/deflectionsimulator.h \
					src/displaywidget.h \
					src/genericdeflectionmodel.h \
					src/lkdeflectionmodel.h \
					src/measurementdata.h \
					src/measurementeditwidget.h \
					src/renishawdeflectionmodel.h

RESOURCES +=		res/deflectionsimulator.qrc

macx{
ICON =				res/icons.icns
QMAKE_INFO_PLIST = ../default_data/Info.plist
}

linux-g++{

isEmpty(PREFIX) {
PREFIX = 			/usr/lib/deflectionsimulator
}
target.path =		$$PREFIX
target.files =		bin/deflectionsimulator
INSTALLS +=			target
}

win32 {
RC_FILE =			res/resource.rc
}
