/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef DEFLECTIONMODELHEADERFILE
#define DEFLECTIONMODELHEADERFILE

#include "../../core/vector3.h"

class TDeflectionModel
{
public:

// CREATORS
	TDeflectionModel(void);
	virtual ~TDeflectionModel(void) = 0;
	
// ACCESSORS
	double Parameter1(void) const {return d_parameter1;}
	double Parameter2(void) const {return d_parameter2;}
	double Parameter3(void) const {return d_parameter3;}
	double Parameter4(void) const {return d_parameter4;}
	
	double Range_Y(void) const {return d_range_y;}
	double Range_Z(void) const {return d_range_z;}
	
	virtual TVector3 Calculate_Correction(const TVector3 &pos) const = 0;
	
// MANIPULATORS
	void Set_Parameter1(const double &dval) {d_parameter1 = dval;}
	void Set_Parameter2(const double &dval) {d_parameter2 = dval;}
	void Set_Parameter3(const double &dval) {d_parameter3 = dval;}
	void Set_Parameter4(const double &dval) {d_parameter4 = dval;}
	
	void Set_Range_Y(const double &d);
	void Set_Range_Z(const double &d);
	
protected:
	
	double								d_parameter1;
	double								d_parameter2;
	double								d_parameter3;
	double								d_parameter4;
	
	double								d_range_y;
	double								d_range_z;
	
private:
	
// NOT IMPLEMENTED
	TDeflectionModel(const TDeflectionModel&);
	TDeflectionModel& operator=(const TDeflectionModel&);
};

#endif
