/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include "genericdeflectionmodel.h"

TGenericDeflectionModel::TGenericDeflectionModel(void)
{
}

TGenericDeflectionModel::~TGenericDeflectionModel(void)
{
}

TVector3 TGenericDeflectionModel::Calculate_Correction(
	const TVector3						&pos) const
{
	double								ryx;
	double								tzy;
	double								tyz;
	double								pos_y(pos.y / 1000.0);	// length in meters
	double								pos_z(pos.z / 1000.0);	// length in meters
	TVector3							correction;
	
	ryx = this->Rotation_YX(pos_y,pos_z);		// angle in radians
	tzy = this->Translation_Y(pos_y,pos_z);
	tyz = this->Translation_Z(pos_y,pos_z);
	
	correction.y = 0.0 - sin(ryx) * pos_z;		// change in Y axis from Z pos
	correction.z = sin(ryx) * pos_y;			// change in Z axis from Y pos
	
	correction.y -= tzy;						// change in Y axis
	correction.z += tyz;						// change in Z axis

	return correction;
}

double TGenericDeflectionModel::Rotation_YX(
	const double 						&pos_y,
	const double 						&pos_z) const
{
	double								result;
	double								factor_y;
	double								factor_z;
	
	factor_y = pos_y / (d_range_y / 1000);
	factor_z = pos_z / (d_range_z / 1000);
	
	result = d_parameter1 * factor_y * factor_z;
	
	return result;
}

double TGenericDeflectionModel::Translation_Y(
	const double 						&pos_y,
	const double 						&pos_z) const
{
	double								result;
	double								factor_y;
	double								factor_z;
	
	factor_y = pos_y / (d_range_y / 1000);
	factor_z = pos_z / (d_range_z / 1000);
	
	result = d_parameter2 * factor_y * factor_z;
	
	return result;
}

double TGenericDeflectionModel::Translation_Z(
	const double 						&pos_y,
	const double 						&pos_z) const
{
	double								result;
	double								factor_y;
	double								factor_z;
	
	factor_y = pos_y / (d_range_y / 1000);
	factor_z = pos_z / (d_range_z / 1000);
	
	result = d_parameter3 * factor_y * factor_z;

	return result;
}


