/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef LKDEFLECTIONMODELHEADERFILE
#define LKDEFLECTIONMODELHEADERFILE

#include "deflectionmodel.h"

class TLKDeflectionModel : public TDeflectionModel
{
public:
	// CREATOR
	TLKDeflectionModel(void);
	virtual ~TLKDeflectionModel(void);
	
	// ACCESSOR
	
	virtual TVector3 Calculate_Correction(const TVector3 &pos) const;
	
	// MANIPULATOR
	
private:
	
	double Rotation_YX(const double &pos_y,const double &pos_z) const;
	double Translation_Y(const double &pos_y,const double &pos_z) const;
	
	
	// NOT IMPLEMENTED
	TLKDeflectionModel(const TLKDeflectionModel&);
	TLKDeflectionModel& operator=(const TLKDeflectionModel&);
};
#endif
