/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <QApplication>
#include <cmath>
#include <assert.h>

#include "renishawdeflectionmodel.h"

TRenishawDeflectionModel::TRenishawDeflectionModel(void)
{
}

TRenishawDeflectionModel::~TRenishawDeflectionModel(void)
{
}

TVector3 TRenishawDeflectionModel::Calculate_Correction(
	const TVector3						&pos) const
{
	TVector3							correction;
	double								pos_y(pos.y / 1000.0);	// length in meters
	double								pos_z(pos.z / 1000.0);	// length in meters
	double								rot_blend23;
	double								rot_blend11;

	rot_blend23 = this->RotationZ_Blend23(pos_y,pos_z);
	rot_blend11 = this->RotationY_Blend11(pos_y,pos_z);
 
	correction.y = rot_blend11 - d_parameter1 * pos_y * pos_z;
	correction.z = rot_blend23 * pos_y + d_parameter1 * pos_y;

	return correction;
}

double TRenishawDeflectionModel::RotationZ_Blend23(
	const double 						&pos_y,
	const double 						&pos_z) const
{
	double								result;
	
	result = (2.0 * d_parameter2 * pos_y * pos_z);					// pos_y * pos_z
	result += (3.0 * d_parameter3 * pos_y * pos_z * pos_z);			// pos_y * pos_z^2

	return result;
}

double TRenishawDeflectionModel::RotationY_Blend11(
	const double 						&pos_y,
	const double 						&pos_z) const
{
	double								result;
	
	result = d_parameter2 * pos_y * pos_z * pos_z;				// pos_y * pos_z^2
	result += d_parameter3 * pos_y * pos_z * pos_z * pos_z;		// pos_y * pos_z^3
	
	return result;
}


