/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef LIBRARYEDITDIALOGHEADERFILE
#define LIBRARYEDITDIALOGHEADERFILE

#include <QDialog>

#include "types.h"

class QComboBox;
class QLineEdit;
class QPushButton;
class QLabel;

class TLibraryEditDialog : public QDialog
{
Q_OBJECT

public:
	
struct TEditData
{
	QString								target_name;
	QString								library_name;
	TTypes::TLibraryType				type;
};

// CREATORS
	TLibraryEditDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TLibraryEditDialog(void);

// ACCESSORS
	TEditData Data(void) const;

// MANIPULATORS
	void Reset(const TTypes::TEditorType type,const QStringList &target_names);
	void Set_Target_Name(const QString &name);
	void Set_Library_Name(const QString &name);
	void Set_Library_Type(const TTypes::TLibraryType type);

signals:

private slots:
	void Validate_Entries(void);

private:
	QComboBox							*d_library_type_combo;
	QLineEdit							*d_target_name_edit;
	QLineEdit							*d_library_name_edit;
	QPushButton							*d_accept_button;
	QPushButton							*d_cancel_button;
	QLabel								*d_target_name_label;
	QLabel								*d_library_name_label;
	QLabel								*d_library_type_label;

	QStringList							d_existing_target_names;
	TTypes::TEditorType					d_editor_type;

// NOT IMPLEMENTED
	TLibraryEditDialog(const TLibraryEditDialog&);
	TLibraryEditDialog& operator=(const TLibraryEditDialog&);
};

#endif
