/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef VARIABLESHEADERFILE
#define VARIABLESHEADERFILE

#include <QWidget>
#include <QString>
#include <vector>

class QPlainTextEdit;
class QTableWidget;
class QToolButton;

class TVariableEditor;
class TXmlFile;

class TVariablesWidget : public QWidget
{
Q_OBJECT

public:
	
struct TVariable
{
	QString								name;
	QString								value;
};

// CREATORS
	TVariablesWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TVariablesWidget(void);

// ACCESSORS
	bool Save_Defaults(const QString &file_path);
	bool Save_Alternate(const QString &file_path);

	int Count(void) const {return static_cast<int>(d_variables.size());}
	TVariable Variable(const int index) const;
	QString Description(void) const;
	
// MANIPULATORS
	bool Load_Defaults(const QString &file_path);
	bool Load_Alternate(const QString &file_path);
	
	void Clear_Variables(void);
	void Add_Variable(const TVariable &variable);
	void Update_Table(void);
	void Update_Variables(void);
	
	void Clear_Description(void);
	void Add_Description_Line(const QString &line);

signals:

private slots:
	void Selection_Changed(void);
	void Move_Item_Up(void);
	void Move_Item_Down(void);
	void Add_Item(void);
	void Remove_Item(void);
	void Store_Alternate(void);
	void Restore_Alternate(void);

private:
	
	QPlainTextEdit						*d_description_edit;
	QTableWidget						*d_variable_table;
	QToolButton							*d_moveup_button;
	QToolButton							*d_movedown_button;
	QToolButton							*d_add_button;
	QToolButton							*d_remove_button;
	QToolButton							*d_restore_button;
	QToolButton							*d_store_button;

	TVariableEditor						*d_variable_editor;
	
	std::vector<TVariable>				d_variables;
	QString								d_default_file_path;
	
	mutable QString						d_last_error;
	
	void Initialize_Variables(void);
	
	void Update_Variable_Data(void);
	void Update_Table_Data(void);
	
	void Load_V1(TXmlFile * const xml_file);
	
// NOT IMPLEMENTED
	TVariablesWidget(const TVariablesWidget&);
	TVariablesWidget& operator=(const TVariablesWidget&);
};

#endif

